/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.datagen;

import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.hibiscus.naturespirit.registration.NSMiscBlocks;
import net.hibiscus.naturespirit.registration.NSRegistryHelper;
import net.hibiscus.naturespirit.registration.NSTags;
import net.hibiscus.naturespirit.registration.NSWoods;
import net.hibiscus.naturespirit.registration.sets.FlowerSet;
import net.hibiscus.naturespirit.registration.sets.StoneSet;
import net.hibiscus.naturespirit.registration.sets.WoodSet;
import net.minecraft.class_2248;
import net.minecraft.class_3481;
import net.minecraft.class_7225;

public class NSBlockTagGenerator
extends FabricTagProvider.BlockTagProvider {
    public NSBlockTagGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    private void addWoodTags(HashMap<String, WoodSet> woods) {
        for (WoodSet woodSet : woods.values()) {
            this.getOrCreateTagBuilder(class_3481.field_15471).add((Object[])new class_2248[]{woodSet.getPlanks()});
            this.getOrCreateTagBuilder(class_3481.field_15499).add((Object[])new class_2248[]{woodSet.getButton()});
            this.getOrCreateTagBuilder(class_3481.field_15494).add((Object[])new class_2248[]{woodSet.getDoor()});
            this.getOrCreateTagBuilder(class_3481.field_15502).add((Object[])new class_2248[]{woodSet.getStairs()});
            this.getOrCreateTagBuilder(class_3481.field_15468).add((Object[])new class_2248[]{woodSet.getSlab()});
            this.getOrCreateTagBuilder(class_3481.field_17619).add((Object[])new class_2248[]{woodSet.getFence()});
            this.getOrCreateTagBuilder(woodSet.getBlockLogsTag()).add((Object[])new class_2248[]{woodSet.getStrippedLog(), woodSet.getLog()});
            this.getOrCreateTagBuilder(NSTags.Blocks.STRIPPED_LOGS).add((Object)woodSet.getStrippedLog());
            this.getOrCreateTagBuilder(class_3481.field_39030).add((Object[])new class_2248[]{woodSet.getLog()});
            this.getOrCreateTagBuilder(class_3481.field_23210).addTag(woodSet.getBlockLogsTag());
            if (woodSet.getWoodPreset() == WoodSet.WoodPreset.JOSHUA) {
                this.getOrCreateTagBuilder(woodSet.getBlockLogsTag()).add((Object[])new class_2248[]{woodSet.getStrippedBundle(), woodSet.getBundle()});
                this.getOrCreateTagBuilder(NSTags.Blocks.STRIPPED_LOGS).add((Object)woodSet.getStrippedBundle());
            }
            if (woodSet.hasBark()) {
                this.getOrCreateTagBuilder(woodSet.getBlockLogsTag()).add((Object[])new class_2248[]{woodSet.getStrippedWood(), woodSet.getWood()});
                this.getOrCreateTagBuilder(NSTags.Blocks.STRIPPED_LOGS).add((Object)woodSet.getStrippedWood());
            }
            if (woodSet.hasMosaic()) {
                this.getOrCreateTagBuilder(class_3481.field_15469).add((Object)woodSet.getMosaicSlab());
                this.getOrCreateTagBuilder(class_3481.field_15459).add((Object)woodSet.getMosaicStairs());
                this.getOrCreateTagBuilder(class_3481.field_33713).add((Object[])new class_2248[]{woodSet.getMosaic(), woodSet.getMosaicSlab(), woodSet.getMosaicStairs()});
            }
            if (woodSet.getWoodPreset() == WoodSet.WoodPreset.WILLOW) {
                this.getOrCreateTagBuilder(class_3481.field_22414).add((Object[])new class_2248[]{woodSet.getVinesPlant(), woodSet.getVines()});
            }
            this.getOrCreateTagBuilder(class_3481.field_15491).add((Object[])new class_2248[]{woodSet.getTrapDoor()});
            this.getOrCreateTagBuilder(class_3481.field_15472).add((Object[])new class_2248[]{woodSet.getSign()});
            this.getOrCreateTagBuilder(class_3481.field_15492).add((Object[])new class_2248[]{woodSet.getWallSign()});
            this.getOrCreateTagBuilder(class_3481.field_15477).add((Object[])new class_2248[]{woodSet.getPressurePlate()});
            this.getOrCreateTagBuilder(class_3481.field_25147).add((Object[])new class_2248[]{woodSet.getFenceGate()});
            this.getOrCreateTagBuilder(class_3481.field_40103).add((Object)woodSet.getHangingSign());
            this.getOrCreateTagBuilder(class_3481.field_40104).add((Object)woodSet.getHangingWallSign());
        }
    }

    private void addStoneTags(HashMap<String, StoneSet> stones) {
        for (StoneSet stoneSet : stones.values()) {
            this.getOrCreateTagBuilder(class_3481.field_33715).add((Object[])stoneSet.getRegisteredBlocksList().toArray(new class_2248[0]));
            if (stoneSet.hasTiles()) {
                this.getOrCreateTagBuilder(class_3481.field_15469).add((Object)stoneSet.getTilesSlab());
                this.getOrCreateTagBuilder(class_3481.field_15459).add((Object)stoneSet.getTilesStairs());
                this.getOrCreateTagBuilder(class_3481.field_15504).add((Object)stoneSet.getTilesWall());
            }
            if (stoneSet.hasCobbled()) {
                this.getOrCreateTagBuilder(class_3481.field_15469).add((Object)stoneSet.getCobbledSlab());
                this.getOrCreateTagBuilder(class_3481.field_15459).add((Object)stoneSet.getCobbledStairs());
                this.getOrCreateTagBuilder(class_3481.field_15504).add((Object)stoneSet.getCobbledWall());
                if (stoneSet.hasMossy()) {
                    this.getOrCreateTagBuilder(class_3481.field_15469).add((Object)stoneSet.getMossyCobbledSlab());
                    this.getOrCreateTagBuilder(class_3481.field_15459).add((Object)stoneSet.getMossyCobbledStairs());
                    this.getOrCreateTagBuilder(class_3481.field_15504).add((Object)stoneSet.getMossyCobbledWall());
                }
            }
            if (stoneSet.hasMossy()) {
                this.getOrCreateTagBuilder(class_3481.field_15469).add((Object)stoneSet.getMossyBricksSlab());
                this.getOrCreateTagBuilder(class_3481.field_15459).add((Object)stoneSet.getMossyBricksStairs());
                this.getOrCreateTagBuilder(class_3481.field_15504).add((Object)stoneSet.getMossyBricksWall());
            }
            this.getOrCreateTagBuilder(class_3481.field_15469).add((Object)stoneSet.getPolishedSlab());
            this.getOrCreateTagBuilder(class_3481.field_15459).add((Object)stoneSet.getPolishedStairs());
            this.getOrCreateTagBuilder(class_3481.field_15504).add((Object)stoneSet.getPolishedWall());
            this.getOrCreateTagBuilder(class_3481.field_15469).add((Object)stoneSet.getBricksSlab());
            this.getOrCreateTagBuilder(class_3481.field_15459).add((Object)stoneSet.getBricksStairs());
            this.getOrCreateTagBuilder(class_3481.field_15504).add((Object)stoneSet.getBricksWall());
            this.getOrCreateTagBuilder(class_3481.field_15469).add((Object)stoneSet.getBaseSlab());
            this.getOrCreateTagBuilder(class_3481.field_15459).add((Object)stoneSet.getBaseStairs());
        }
    }

    private void addTreeTags(HashMap<String, class_2248[]> saplings, HashMap<String, class_2248> leaves) {
        for (String i : leaves.keySet()) {
            class_2248 leavesType = leaves.get(i);
            this.getOrCreateTagBuilder(class_3481.field_33714).add((Object)leavesType);
            this.getOrCreateTagBuilder(class_3481.field_15503).add((Object)leavesType);
            if (Objects.equals(i, "wisteria") || Objects.equals(i, "coconut") || i.startsWith("part") || i.startsWith("frosty") || Objects.equals(i, "yellow_aspen")) continue;
            class_2248[] saplingType = saplings.get(i);
            this.getOrCreateTagBuilder(class_3481.field_15462).add((Object[])new class_2248[]{saplingType[0]});
            this.getOrCreateTagBuilder(class_3481.field_15470).add((Object[])new class_2248[]{saplingType[1]});
        }
    }

    protected void method_10514(class_7225.class_7874 arg) {
        this.addWoodTags(NSRegistryHelper.WoodHashMap);
        this.addStoneTags(NSRegistryHelper.StoneHashMap);
        this.addTreeTags(NSRegistryHelper.SaplingHashMap, NSRegistryHelper.LeavesHashMap);
        for (FlowerSet flowerSet : NSRegistryHelper.FlowerHashMap.values()) {
            if (flowerSet.isTall()) {
                this.getOrCreateTagBuilder(class_3481.field_20338).add((Object)flowerSet.getFlowerBlock());
            } else {
                this.getOrCreateTagBuilder(class_3481.field_15470).add((Object)flowerSet.getPottedFlowerBlock());
                this.getOrCreateTagBuilder(class_3481.field_15480).add((Object)flowerSet.getFlowerBlock());
            }
            this.getOrCreateTagBuilder(class_3481.field_44469).add((Object)flowerSet.getFlowerBlock());
            this.getOrCreateTagBuilder(class_3481.field_44470).add((Object)flowerSet.getFlowerBlock());
        }
        this.getOrCreateTagBuilder(class_3481.field_44471).add((Object)NSMiscBlocks.AZOLLA);
        this.getOrCreateTagBuilder(class_3481.field_20338).add((Object)NSMiscBlocks.CATTAIL);
        this.getOrCreateTagBuilder(class_3481.field_20339).add((Object[])new class_2248[]{NSMiscBlocks.LOTUS_FLOWER, NSWoods.WISTERIA.getBlueVines(), NSWoods.WISTERIA.getBlueVinesPlant(), NSWoods.WISTERIA.getWhiteVines(), NSWoods.WISTERIA.getWhiteVinesPlant(), NSWoods.WISTERIA.getPinkVines(), NSWoods.WISTERIA.getPinkVinesPlant(), NSWoods.WISTERIA.getPurpleVines(), NSWoods.WISTERIA.getPurpleVinesPlant(), NSWoods.WISTERIA.getBlueLeaves(), NSWoods.WISTERIA.getWhiteLeaves(), NSWoods.WISTERIA.getPinkLeaves(), NSWoods.WISTERIA.getPurpleLeaves()});
        this.getOrCreateTagBuilder(NSTags.Blocks.ALLUAUDIA_BLOCKS).add((Object[])new class_2248[]{NSMiscBlocks.STRIPPED_ALLUAUDIA_BUNDLE, NSMiscBlocks.ALLUAUDIA_BUNDLE, NSMiscBlocks.ALLUAUDIA, NSMiscBlocks.STRIPPED_ALLUAUDIA});
        this.getOrCreateTagBuilder(class_3481.field_33713).addTag(NSTags.Blocks.ALLUAUDIA_BLOCKS);
        this.getOrCreateTagBuilder(class_3481.field_15494).add((Object[])new class_2248[]{NSMiscBlocks.PAPER_DOOR, NSMiscBlocks.FRAMED_PAPER_DOOR, NSMiscBlocks.BLOOMING_PAPER_DOOR});
        this.getOrCreateTagBuilder(class_3481.field_15491).add((Object[])new class_2248[]{NSMiscBlocks.PAPER_TRAPDOOR, NSMiscBlocks.FRAMED_PAPER_TRAPDOOR, NSMiscBlocks.BLOOMING_PAPER_TRAPDOOR});
        this.getOrCreateTagBuilder(class_3481.field_22414).add((Object[])new class_2248[]{NSWoods.WISTERIA.getBlueVines(), NSWoods.WISTERIA.getBlueVinesPlant(), NSWoods.WISTERIA.getWhiteVines(), NSWoods.WISTERIA.getWhiteVinesPlant(), NSWoods.WISTERIA.getPinkVines(), NSWoods.WISTERIA.getPinkVinesPlant(), NSWoods.WISTERIA.getPurpleVines(), NSWoods.WISTERIA.getPurpleVinesPlant(), NSWoods.WILLOW.getVinesPlant(), NSWoods.WILLOW.getVines()});
        this.getOrCreateTagBuilder(class_3481.field_20342).add((Object[])new class_2248[]{NSWoods.WISTERIA.getBlueVines(), NSWoods.WISTERIA.getBlueVinesPlant(), NSWoods.WISTERIA.getWhiteVines(), NSWoods.WISTERIA.getWhiteVinesPlant(), NSWoods.WISTERIA.getPinkVines(), NSWoods.WISTERIA.getPinkVinesPlant(), NSWoods.WISTERIA.getPurpleVines(), NSWoods.WISTERIA.getPurpleVinesPlant(), NSMiscBlocks.LOTUS_FLOWER});
        this.getOrCreateTagBuilder(class_3481.field_38694).forceAddTag(NSTags.Blocks.KAOLIN);
        this.getOrCreateTagBuilder(class_3481.field_29822).add((Object[])new class_2248[]{NSMiscBlocks.SANDY_SOIL, NSMiscBlocks.CHERT.getBase(), NSMiscBlocks.RED_MOSS_BLOCK});
        this.getOrCreateTagBuilder(class_3481.field_38832).add((Object[])new class_2248[]{NSMiscBlocks.PINK_SANDSTONE, NSMiscBlocks.RED_MOSS_BLOCK}).forceAddTag(NSTags.Blocks.KAOLIN).forceAddTag(NSTags.Blocks.KAOLIN);
        this.getOrCreateTagBuilder(class_3481.field_20341).add((Object)NSMiscBlocks.DESERT_TURNIP_STEM);
        this.getOrCreateTagBuilder(class_3481.field_44589).add((Object)NSMiscBlocks.DESERT_TURNIP_STEM);
        this.getOrCreateTagBuilder(class_3481.field_33714).add((Object[])new class_2248[]{NSMiscBlocks.SCORCHED_GRASS, NSMiscBlocks.TALL_SCORCHED_GRASS, NSMiscBlocks.BEACH_GRASS, NSMiscBlocks.TALL_BEACH_GRASS, NSMiscBlocks.SEDGE_GRASS, NSMiscBlocks.TALL_SEDGE_GRASS, NSMiscBlocks.LARGE_FLAXEN_FERN, NSMiscBlocks.FLAXEN_FERN, NSMiscBlocks.LARGE_LUSH_FERN, NSMiscBlocks.LUSH_FERN, NSMiscBlocks.TALL_MELIC_GRASS, NSMiscBlocks.MELIC_GRASS, NSMiscBlocks.FRIGID_GRASS, NSMiscBlocks.TALL_FRIGID_GRASS, NSMiscBlocks.OAT_GRASS, NSMiscBlocks.TALL_OAT_GRASS, NSMiscBlocks.RED_BEARBERRIES, NSMiscBlocks.GREEN_BEARBERRIES, NSMiscBlocks.PURPLE_BEARBERRIES, NSMiscBlocks.RED_BITTER_SPROUTS, NSMiscBlocks.PURPLE_BITTER_SPROUTS, NSMiscBlocks.GREEN_BITTER_SPROUTS, NSWoods.COCONUT_THATCH, NSWoods.COCONUT_THATCH_STAIRS, NSWoods.COCONUT_THATCH_CARPET, NSWoods.COCONUT_THATCH_SLAB, NSWoods.EVERGREEN_THATCH, NSWoods.EVERGREEN_THATCH_STAIRS, NSWoods.EVERGREEN_THATCH_CARPET, NSWoods.EVERGREEN_THATCH_SLAB, NSWoods.XERIC_THATCH, NSWoods.XERIC_THATCH_STAIRS, NSWoods.XERIC_THATCH_CARPET, NSWoods.XERIC_THATCH_SLAB, NSMiscBlocks.RED_MOSS_BLOCK, NSMiscBlocks.RED_MOSS_CARPET, NSMiscBlocks.ORNATE_SUCCULENT, NSMiscBlocks.AUREATE_SUCCULENT, NSMiscBlocks.SAGE_SUCCULENT, NSMiscBlocks.FOAMY_SUCCULENT, NSMiscBlocks.IMPERIAL_SUCCULENT, NSMiscBlocks.REGAL_SUCCULENT});
        this.getOrCreateTagBuilder(class_3481.field_44469).add((Object[])new class_2248[]{NSMiscBlocks.SCORCHED_GRASS, NSMiscBlocks.TALL_SCORCHED_GRASS, NSMiscBlocks.BEACH_GRASS, NSMiscBlocks.TALL_BEACH_GRASS, NSMiscBlocks.SEDGE_GRASS, NSMiscBlocks.TALL_SEDGE_GRASS, NSMiscBlocks.LARGE_FLAXEN_FERN, NSMiscBlocks.FLAXEN_FERN, NSMiscBlocks.SHIITAKE_MUSHROOM, NSMiscBlocks.GRAY_POLYPORE, NSMiscBlocks.FRIGID_GRASS, NSMiscBlocks.TALL_FRIGID_GRASS, NSMiscBlocks.OAT_GRASS, NSMiscBlocks.TALL_OAT_GRASS, NSMiscBlocks.LARGE_LUSH_FERN, NSMiscBlocks.LUSH_FERN, NSMiscBlocks.TALL_MELIC_GRASS, NSMiscBlocks.MELIC_GRASS, NSMiscBlocks.RED_BEARBERRIES, NSMiscBlocks.GREEN_BEARBERRIES, NSMiscBlocks.PURPLE_BEARBERRIES, NSMiscBlocks.RED_BITTER_SPROUTS, NSMiscBlocks.PURPLE_BITTER_SPROUTS, NSMiscBlocks.GREEN_BITTER_SPROUTS});
        this.getOrCreateTagBuilder(class_3481.field_44470).add((Object[])new class_2248[]{NSMiscBlocks.SCORCHED_GRASS, NSMiscBlocks.TALL_SCORCHED_GRASS, NSMiscBlocks.BEACH_GRASS, NSMiscBlocks.TALL_BEACH_GRASS, NSMiscBlocks.SEDGE_GRASS, NSMiscBlocks.TALL_SEDGE_GRASS, NSMiscBlocks.LARGE_FLAXEN_FERN, NSMiscBlocks.FLAXEN_FERN, NSMiscBlocks.FRIGID_GRASS, NSMiscBlocks.TALL_FRIGID_GRASS, NSMiscBlocks.OAT_GRASS, NSMiscBlocks.TALL_OAT_GRASS, NSMiscBlocks.LARGE_LUSH_FERN, NSMiscBlocks.LUSH_FERN, NSMiscBlocks.TALL_MELIC_GRASS, NSMiscBlocks.MELIC_GRASS, NSMiscBlocks.AUREATE_SUCCULENT, NSMiscBlocks.SAGE_SUCCULENT, NSMiscBlocks.FOAMY_SUCCULENT, NSMiscBlocks.IMPERIAL_SUCCULENT, NSMiscBlocks.REGAL_SUCCULENT});
        this.getOrCreateTagBuilder(class_3481.field_15466).add((Object[])new class_2248[]{NSMiscBlocks.PINK_SAND, NSMiscBlocks.SANDY_SOIL});
        this.getOrCreateTagBuilder(class_3481.field_42968).add((Object)NSMiscBlocks.PINK_SAND);
        this.getOrCreateTagBuilder(class_3481.field_33716).add((Object[])new class_2248[]{NSMiscBlocks.PINK_SAND, NSMiscBlocks.SANDY_SOIL});
        this.getOrCreateTagBuilder(class_3481.field_33715).forceAddTag(NSTags.Blocks.KAOLIN).forceAddTag(NSTags.Blocks.KAOLIN_STAIRS).forceAddTag(NSTags.Blocks.KAOLIN_SLABS).forceAddTag(NSTags.Blocks.KAOLIN_BRICKS).forceAddTag(NSTags.Blocks.KAOLIN_BRICK_STAIRS).forceAddTag(NSTags.Blocks.KAOLIN_BRICK_SLABS).forceAddTag(NSTags.Blocks.CHALK).forceAddTag(NSTags.Blocks.CHALK_STAIRS).forceAddTag(NSTags.Blocks.CHALK_SLABS).add((Object[])new class_2248[]{NSMiscBlocks.CHERT_COAL_ORE, NSMiscBlocks.CHERT_COPPER_ORE, NSMiscBlocks.CHERT_DIAMOND_ORE, NSMiscBlocks.CHERT_GOLD_ORE, NSMiscBlocks.CHERT_EMERALD_ORE, NSMiscBlocks.CHERT_IRON_ORE, NSMiscBlocks.CHERT_LAPIS_ORE, NSMiscBlocks.CHERT_REDSTONE_ORE, NSMiscBlocks.PINK_SANDSTONE, NSMiscBlocks.SMOOTH_PINK_SANDSTONE, NSMiscBlocks.CUT_PINK_SANDSTONE, NSMiscBlocks.PINK_SANDSTONE_STAIRS, NSMiscBlocks.SMOOTH_PINK_SANDSTONE_STAIRS, NSMiscBlocks.PINK_SANDSTONE_SLAB, NSMiscBlocks.SMOOTH_PINK_SANDSTONE_SLAB, NSMiscBlocks.CUT_PINK_SANDSTONE_SLAB, NSMiscBlocks.PINK_SANDSTONE_WALL, NSMiscBlocks.CHISELED_PINK_SANDSTONE});
        this.getOrCreateTagBuilder(class_3481.field_15459).add((Object[])new class_2248[]{NSMiscBlocks.PINK_SANDSTONE_STAIRS, NSMiscBlocks.SMOOTH_PINK_SANDSTONE_STAIRS, NSWoods.EVERGREEN_THATCH_STAIRS, NSWoods.COCONUT_THATCH_STAIRS});
        this.getOrCreateTagBuilder(class_3481.field_15469).add((Object[])new class_2248[]{NSMiscBlocks.PINK_SANDSTONE_SLAB, NSMiscBlocks.SMOOTH_PINK_SANDSTONE_SLAB, NSMiscBlocks.CUT_PINK_SANDSTONE_SLAB, NSWoods.EVERGREEN_THATCH_SLAB, NSWoods.COCONUT_THATCH_SLAB});
        this.getOrCreateTagBuilder(class_3481.field_15504).add((Object)NSMiscBlocks.PINK_SANDSTONE_WALL);
        this.getOrCreateTagBuilder(class_3481.field_26985).add((Object[])new class_2248[]{NSMiscBlocks.CHEESE_CAULDRON, NSMiscBlocks.MILK_CAULDRON});
        this.getOrCreateTagBuilder(class_3481.field_15470).add((Object[])new class_2248[]{NSMiscBlocks.POTTED_MELIC_GRASS, NSMiscBlocks.POTTED_FLAXEN_FERN, NSMiscBlocks.POTTED_FRIGID_GRASS, NSMiscBlocks.POTTED_SHIITAKE_MUSHROOM, NSMiscBlocks.POTTED_BEACH_GRASS, NSMiscBlocks.POTTED_SEDGE_GRASS, NSMiscBlocks.POTTED_SCORCHED_GRASS, NSMiscBlocks.POTTED_OAT_GRASS, NSMiscBlocks.POTTED_LUSH_FERN, NSMiscBlocks.POTTED_ORNATE_SUCCULENT, NSMiscBlocks.POTTED_DROWSY_SUCCULENT, NSMiscBlocks.POTTED_AUREATE_SUCCULENT, NSMiscBlocks.POTTED_SAGE_SUCCULENT, NSMiscBlocks.POTTED_FOAMY_SUCCULENT, NSMiscBlocks.POTTED_IMPERIAL_SUCCULENT});
        this.getOrCreateTagBuilder(class_3481.field_15460).add((Object)NSMiscBlocks.SHIITAKE_MUSHROOM);
        this.getOrCreateTagBuilder(class_3481.field_33713).add((Object[])new class_2248[]{NSMiscBlocks.SHIITAKE_MUSHROOM, NSMiscBlocks.SHIITAKE_MUSHROOM_BLOCK, NSMiscBlocks.GRAY_POLYPORE, NSMiscBlocks.GRAY_POLYPORE_BLOCK, NSMiscBlocks.DESERT_TURNIP_BLOCK, NSMiscBlocks.DESERT_TURNIP_ROOT_BLOCK, NSMiscBlocks.DESERT_TURNIP_STEM, NSMiscBlocks.PAPER_BLOCK, NSMiscBlocks.PAPER_PANEL, NSMiscBlocks.PAPER_DOOR, NSMiscBlocks.PAPER_SIGN, NSMiscBlocks.PAPER_WALL_SIGN, NSMiscBlocks.PAPER_HANGING_SIGN, NSMiscBlocks.PAPER_WALL_HANGING_SIGN, NSMiscBlocks.FRAMED_PAPER_BLOCK, NSMiscBlocks.FRAMED_PAPER_PANEL, NSMiscBlocks.FRAMED_PAPER_DOOR, NSMiscBlocks.FRAMED_PAPER_TRAPDOOR, NSMiscBlocks.BLOOMING_PAPER_BLOCK, NSMiscBlocks.BLOOMING_PAPER_DOOR, NSMiscBlocks.BLOOMING_PAPER_TRAPDOOR, NSMiscBlocks.BLOOMING_PAPER_PANEL});
        this.getOrCreateTagBuilder(class_3481.field_40103).add((Object)NSMiscBlocks.PAPER_HANGING_SIGN);
        this.getOrCreateTagBuilder(class_3481.field_40104).add((Object)NSMiscBlocks.PAPER_WALL_HANGING_SIGN);
        this.getOrCreateTagBuilder(class_3481.field_15472).add((Object[])new class_2248[]{NSMiscBlocks.PAPER_SIGN});
        this.getOrCreateTagBuilder(class_3481.field_15492).add((Object[])new class_2248[]{NSMiscBlocks.PAPER_WALL_SIGN});
        this.getOrCreateTagBuilder(class_3481.field_29193).add((Object)NSMiscBlocks.CHERT_COAL_ORE);
        this.getOrCreateTagBuilder(class_3481.field_29195).add((Object)NSMiscBlocks.CHERT_COPPER_ORE);
        this.getOrCreateTagBuilder(class_3481.field_28989).add((Object)NSMiscBlocks.CHERT_DIAMOND_ORE);
        this.getOrCreateTagBuilder(class_3481.field_23062).add((Object)NSMiscBlocks.CHERT_GOLD_ORE);
        this.getOrCreateTagBuilder(class_3481.field_29194).add((Object)NSMiscBlocks.CHERT_EMERALD_ORE);
        this.getOrCreateTagBuilder(class_3481.field_28988).add((Object)NSMiscBlocks.CHERT_IRON_ORE);
        this.getOrCreateTagBuilder(class_3481.field_28991).add((Object)NSMiscBlocks.CHERT_LAPIS_ORE);
        this.getOrCreateTagBuilder(class_3481.field_28990).add((Object)NSMiscBlocks.CHERT_REDSTONE_ORE);
        this.getOrCreateTagBuilder(class_3481.field_33718).add((Object[])new class_2248[]{NSMiscBlocks.CHERT_EMERALD_ORE, NSMiscBlocks.CHERT_DIAMOND_ORE, NSMiscBlocks.CHERT_GOLD_ORE, NSMiscBlocks.CHERT_REDSTONE_ORE});
        this.getOrCreateTagBuilder(class_3481.field_33719).add((Object[])new class_2248[]{NSMiscBlocks.CHERT_COPPER_ORE, NSMiscBlocks.CHERT_IRON_ORE, NSMiscBlocks.CHERT_LAPIS_ORE});
        this.getOrCreateTagBuilder(class_3481.field_28992).add((Object)NSMiscBlocks.TRAVERTINE.getBase());
        this.getOrCreateTagBuilder(class_3481.field_25806).add((Object)NSMiscBlocks.TRAVERTINE.getBase());
        this.getOrCreateTagBuilder(class_3481.field_25806).add((Object)NSMiscBlocks.CHERT.getBase());
        this.getOrCreateTagBuilder(class_3481.field_15459).forceAddTag(NSTags.Blocks.CHALK_STAIRS).forceAddTag(NSTags.Blocks.KAOLIN_STAIRS).forceAddTag(NSTags.Blocks.KAOLIN_BRICK_STAIRS).add((Object[])new class_2248[]{NSMiscBlocks.PINK_SANDSTONE_STAIRS, NSMiscBlocks.SMOOTH_PINK_SANDSTONE_STAIRS});
        this.getOrCreateTagBuilder(class_3481.field_15469).forceAddTag(NSTags.Blocks.CHALK_SLABS).forceAddTag(NSTags.Blocks.KAOLIN_SLABS).forceAddTag(NSTags.Blocks.KAOLIN_SLABS).add((Object[])new class_2248[]{NSMiscBlocks.PINK_SANDSTONE_SLAB, NSMiscBlocks.SMOOTH_PINK_SANDSTONE_SLAB, NSMiscBlocks.CUT_PINK_SANDSTONE_SLAB});
        this.getOrCreateTagBuilder(class_3481.field_15504).add((Object)NSMiscBlocks.PINK_SANDSTONE_WALL);
    }
}

